<?php
/*--------------------------------------------------------------
   Table.php 2021-06-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Data\Factory;

use Gambio\Admin\Modules\Statistics\Model\Collections\TableColumns;
use Gambio\Admin\Modules\Statistics\Model\Collections\TableRowFields;
use Gambio\Admin\Modules\Statistics\Model\Collections\TableRows;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table as TableData;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column as TableColumn;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column\Boolean as TableBooleanColumn;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column\Date as TableDateColumn;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column\Decimal as TableDecimalColumn;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column\Integer as TableIntegerColumn;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column\Percentage as TablePercentageColumn;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Column\Text as TableTextColumn;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row as TableRow;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field as TableRowField;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field\Boolean as TableRowBooleanField;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field\Number as TableRowNumberField;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Table\Row\Field\Text as TableRowTextField;

class Table
{
    /**
     * Return table data.
     */
    public function createTableData(TableColumns $columns, TableRows $rows): TableData
    {
        return TableData::create($columns, $rows);
    }
    
    
    /**
     * Return columns.
     */
    public function createColumns(TableColumn ...$columns): TableColumns
    {
        return TableColumns::create(...$columns);
    }
    
    
    /**
     * Return date column.
     */
    public function createDateColumn(
        string $title,
        string $field,
        string $inputDateFormat,
        string $outputDateFormat
    ): TableDateColumn {
        return TableDateColumn::create($title, $field, $inputDateFormat, $outputDateFormat);
    }
    
    
    /**
     * Return boolean column.
     */
    public function createBooleanColumn(string $title, string $field): TableBooleanColumn
    {
        return TableBooleanColumn::create($title, $field);
    }
    
    
    /**
     * Return decimal column.
     */
    public function createDecimalColumn(string $title, string $field): TableDecimalColumn
    {
        return TableDecimalColumn::create($title, $field);
    }
    
    
    /**
     * Return percentage column.
     */
    public function createPercentageColumn(string $title, string $field): TablePercentageColumn
    {
        return TablePercentageColumn::create($title, $field);
    }
    
    
    /**
     * Return text column.
     */
    public function createTextColumn(string $title, string $field): TableTextColumn
    {
        return TableTextColumn::create($title, $field);
    }
    
    
    /**
     * Return integer column.
     */
    public function createIntegerColumn(string $title, string $field): TableIntegerColumn
    {
        return TableIntegerColumn::create($title, $field);
    }
    
    
    /**
     * Return rows.
     */
    public function createRows(TableRow ...$rows): TableRows
    {
        return TableRows::create(...$rows);
    }
    
    
    /**
     * Return row.
     */
    public function createRow(TableRowFields $fields): TableRow
    {
        return TableRow::create($fields);
    }
    
    
    /**
     * Return row fields.
     */
    public function createRowFields(TableRowField ...$fields): TableRowFields
    {
        return TableRowFields::create(...$fields);
    }
    
    
    /**
     * Return text row field.
     */
    public function createRowTextField(string $name, string $value): TableRowTextField
    {
        return TableRowTextField::create($name, $value);
    }
    
    
    /**
     * Return number row field.
     */
    public function createRowNumberField(string $name, float $value): TableRowNumberField
    {
        return TableRowNumberField::create($name, $value);
    }
    
    
    /**
     * Return boolean row field.
     */
    public function createRowBooleanField(string $name, bool $value): TableRowBooleanField
    {
        return TableRowBooleanField::create($name, $value);
    }
}